<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReloadUV extends Model 
{

    protected $table = 'reloads_uv';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('users_id', 'agency_id', 'partner_id', 'users_box_id', 'reloader_id', 'slug', 'amount', 'type', 'status');
    protected $visible = array('users_id', 'agency_id', 'partner_id', 'users_box_id', 'reloader_id', 'slug', 'amount', 'type', 'status');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function agency()
    {
        return $this->belongsTo('App\Models\Agency', 'agency_id');
    }

    public function partner()
    {
        return $this->belongsTo('App\Models\Partner', 'partner_id');
    }

    public function userBox()
    {
        return $this->belongsTo('App\Models\UserBox', 'user_box_id');
    }

    public function reloader()
    {
        return $this->belongsTo('App\Models\User', 'reloader_id');
    }

}